% =========================================================================
%   Praktikum MATLAB/Simulink II
%   Technische Universitt Darmstadt
%   IAT, FG rtm (Prof. Dr.-Ing. U. Konigorski)
%
%   Copyright (c) 2017, FG Regelungstechnik und Mechatronik,
%                       Technische Universitt Darmstadt
%   All rights reserved.
%
%   Redistribution and use in source and binary forms, with or withou
%   modification, are permitted provided that the following conditions are
%   met:
%
%   1. Redistributions of source code must retain the above copyright
%      notice, this list of conditions and the following disclaimer.
%
%   2. Redistributions in binary form must reproduce the above copyright
%      notice, this list of conditions and the following disclaimer in the
%      documentation and/or other materials provided with the distribution.
%
%
%   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
%   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
%   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
%   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
%   HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
%   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
%   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
%   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
%   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
%   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
%   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

% =========================================================================

function sFunctionTemplate(block)
% sFunctionTemplate 
% Dies ist eine Vorlage fr eine Level-2 M-File S-Function.

	setup(block);

end


% *********************************************************
% Initialisierung
% *********************************************************
function setup(block)

	% Anzahl der Ein-/Ausgnge
	block.NumInputPorts  = 1;
	block.NumOutputPorts = 1;

	% Eigenschaften des 1. Eingangs
	block.InputPort(1).Dimensions	= 1;
	block.InputPort(1).DatatypeID	= 0;  % double
	block.InputPort(1).Complexity	= 'Real';
	block.InputPort(1).DirectFeedthrough = false;
	block.InputPort(1).SamplingMode = 'Sample';

	% Eigenschaften des 1. Ausgangs
	block.OutputPort(1).Dimensions	= 1;
	block.OutputPort(1).DatatypeID	= 0; % double
	block.OutputPort(1).Complexity	= 'Real';
	block.OutputPort(1).SamplingMode = 'Sample';

	
	% Anzahl der Zustnde
	block.NumContStates = 2;

	% Anzahl der Parameter
	block.NumDialogPrms = 3;


	% Abtastzeit definieren -> zeitkontinuierlich
	block.SampleTimes = [0 0];


	
	% weitere Methoden registrieren
	block.RegBlockMethod('InitializeConditions', @InitializeConditions);
	block.RegBlockMethod('Outputs', @Outputs);
	block.RegBlockMethod('Derivatives', @Derivatives);
	block.RegBlockMethod('Terminate', @Terminate);

end


% *********************************************************
% Anfangsbedingungen setzen
% *********************************************************
function InitializeConditions(block)

    % Die Anfangsbedingungen werden als Parameter bergeben
	x1_0 = block.DialogPrm(1).Data;
	x2_0 = block.DialogPrm(2).Data;
	
	block.ContStates.Data = [x1_0; x2_0];
	
end


% *********************************************************
% Ausgnge berechnen
% *********************************************************
function Outputs(block)

	% Zustnde auslesen
	x  = block.ContStates.Data;
	x1 = x(1);

	block.OutputPort(1).Data = x1;

end


% *********************************************************
% Ableitungen berechnen
% *********************************************************
function Derivatives(block)

	% Parameter auslesen
	p1 = block.DialogPrm(3).Data;

	% Zustnde auslesen
	x		= block.ContStates.Data;
	x2		= x(2);

	% Eingang auslesen
	u = block.InputPort(1).Data(1);

	
	
	% Ableitungen berechnen
	x1_d = x2;
	x2_d = p1 * u;
	
	

	% Ableitungen zuweisen
	block.Derivatives.Data = [x1_d, x2_d];
	
end


% *********************************************************
% Aufrumen (wenn ntig)
% *********************************************************
function Terminate(block)
end
